import utils
import main
import backup
from variables import*

###############################################################################
#						                                                  FRESH INSTALL
###############################################################################

def freshStart():

	if setSkin not in ['skin.confluence', 'skin.estuary']:
		if currentKodi >= 17:
		    skin = 'skin.confluence'
		else:
		    skin = 'skin.estuary'

		yes=dialog.yesno(addonTitle, "The skin needs to be set back to [COLOR ffff7e14]%s[/COLOR]" % skin[5:], "Please select Yes, Swap Skin Before doing a fresh install", "", nolabel="No, Thanks", yeslabel="Yes, Swap Skin");

		if yes:	
			utils.swapSkins(skin)
			time.sleep(5)
		else: utils.notify(addonTitle,'Fresh Install: [COLOR ffff7e14]Cancelled![/COLOR]'); return
		


	yes_pressed=dialog.yesno(addonTitle,"Do you wish to restore your configuration to default settings?", "", nolabel='No, Cancel', yeslabel='Yes, Continue')
	
	if yes_pressed:

		xbmcPath = xbmc.translatePath(os.path.join('special://home'))
		dialogProgress.create(addonTitle,"Clearing all files and folders:",'', '')
		total_files = sum([len(files) for r, d, files in os.walk(xbmcPath)])
		del_file = 0

		try:
			for root, dirs, files in os.walk(xbmcPath,topdown=True):
				dirs[:] = [d for d in dirs if d not in ignorefresh]
				files[:] = [file for file in files if file not in ignorefresh]		
				for name in files:
					del_file += 1
					dialogProgress.update(int(utils.percentage(del_file, total_files)), '', 'File: [COLOR ffff7e14]%s[/COLOR]' % name, '')

					try: os.remove(os.path.join(root,name))
					except: pass

			for root, dirs, files in os.walk(xbmcPath,topdown=True):
				dirs[:] = [d for d in dirs if d not in ignorefresh]

				for name in dirs:
					dialogProgress.update(100, '', 'Cleaning Up Empty Folder: [COLOR ffff7e14]%s[/COLOR]' % name, '')

					
					if name not in ["Database","userdata","temp","addons","addon_data"]:
						shutil.rmtree(os.path.join(root,name),ignore_errors=True, onerror=None)


			dialogProgress.close()

		except Exception, e:
			dialog.ok(addonTitle, str(e), '','')


		dialogProgress.close()


		dialog.ok(addonTitle, "The process is complete, you're now back to a fresh Kodi configuration","Please press ok to restart Kodi in order for the changes to be applied.")
		killxbmc()

	else: utils.notify(addonTitle,'Fresh Install: [COLOR ffff7e14]Cancelled![/COLOR]'); xbmc.executebuiltin('Container.Refresh')


###############################################################################
#						                                                  KILL XBMC
###############################################################################

def killxbmc():


    if xbmc.getCondVisibility('system.platform.osx'):

        try: os._exit(1)
        except: pass

        try: os.system('killall -9 XBMC')
        except: pass
        try: os.system('killall -9 Kodi')
        except: pass

        dialog.ok("[COLOR red][B]WARNING  !!![/COLOR][/B]", "force close was unsuccessful", "Please force close Kodi. DO NOT exit cleanly via the menu.",'')


    elif xbmc.getCondVisibility('system.platform.linux'):

        try: os._exit(1)
        except: pass

        try: os.system('killall XBMC')
        except: pass
        try: os.system('killall Kodi')
        except: pass
        try: os.system('killall -9 xbmc.bin')
        except: pass
        try: os.system('killall -9 kodi.bin')
        except: pass

        dialog.ok("[COLOR red][B]WARNING  !!![/COLOR][/B]", "force close was unsuccessful", "Please force close Kodi. DO NOT exit cleanly via the menu.",'')


    elif xbmc.getCondVisibility('system.platform.android'):

        try: os._exit(1)
        except: pass
        try: os.system('adb shell am force-stop org.xbmc.kodi')
        except: pass
        try: os.system('adb shell am force-stop org.kodi')
        except: pass
        try: os.system('adb shell am force-stop org.xbmc.xbmc')
        except: pass
        try: os.system('adb shell am force-stop org.xbmc')
        except: pass     
        try: os.system('adb shell am force-stop com.semperpax.spmc16')
        except: pass
        try: os.system('adb shell am force-stop com.spmc16')
        except: pass            
        try: os.system('adb shell am force-stop com.semperpax.spmc')
        except: pass
        try: os.system('adb shell am force-stop com.spmc')
        except: pass    
        try: os.system('adb shell am force-stop uk.droidbox.dbmc')
        except: pass
        try: os.system('adb shell am force-stop uk.dbmc')
        except: pass   
        try: os.system('adb shell am force-stop com.perfectzoneproductions.jesusboxmedia')
        except: pass
        try: os.system('adb shell am force-stop com.jesusboxmedia')
        except: pass 
        dialog.ok("[COLOR red][B]WARNING  !!![/COLOR][/B]", "force close was unsuccessful", "Please force close Kodi. Pulling the power cable is the simplest method to force close.")



    elif xbmc.getCondVisibility('system.platform.windows'):
        try:
            os._exit(1)
        except:
            pass
        try:
            os.system('@ECHO off')
            os.system('tskill XBMC.exe')
        except: pass
        try:
            os.system('@ECHO off')
            os.system('tskill Kodi.exe')
        except: pass
        try:
            os.system('@ECHO off')
            os.system('TASKKILL /im Kodi.exe /f')
        except: pass
        try:
            os.system('@ECHO off')
            os.system('TASKKILL /im XBMC.exe /f')
        except: pass

        dialog.ok("[COLOR red][B]WARNING  !!![/COLOR][/B]", "force close was unsuccessful", "Please force close Kodi DO NOT exit cleanly via the menu.","Use task manager and NOT ALT F4")


    else:
        try: os._exit(1)
        except: pass

       # IOS
        try: os.system('killall AppleTV')
        except: pass

        #OSMC / RASPBMC
        try: os.system('sudo initctl stop kodi')
        except: pass
        try: os.system('sudo initctl stop xbmc')
        except: pass

        dialog.ok("[COLOR red][B]WARNING  !!![/COLOR][/B]", "force close was unsuccessful", "Please force close Kodi. DO NOT exit cleanly via the menu.",'')